'/**********************************************************************************************
'Visual Basic API - file for MEGSV86x64.DLL (Windows 64-Bit)
'For using with GSV-8/BX8 or GSV-6/ITA measuring amplifiers with serial interface
'Copyright 2017 ME-Messysteme GmbH H.Kabelitz
'1. Data types, all little-endian style:
'int: signed Integer of 32 bits size
'unsigned Long : unsigned Integer of 32 bits size
'Double : IEEE754 floating-point value Of 64 bits size

'2. Calling convention: __fastcall

'************************************************************************************************/


Public Class GSV8

    '/* Version of this DLL */
    Public Const FILEVER_H As Integer = 1
    Public Const FILEVER_L As Integer = 14

    '/* Return-codes for Simple errorcode */
    Public Const GSV_OK As Integer = 0 'no error, without signalling information
    Public Const GSV_ERROR As Integer = -1 'an error occurred within the request
    Public Const GSV_TRUE As Integer = 1 'no error, with signalling information

    '/*Constant values used by GSV86*actEx */
    Public Const CONST_BAUDRATE As Integer = 921600 ' Use this also for serial-over-Ethernet connection
    Public Const CONST_BUFSIZE As Integer = 48000

    '/* Flags for parameter "flags" in GSV86activateExtended */
    Public Const ACTEX_FLAG_HANDSHAKE As Integer = 4 ' enables HW-handshake in in GSV86activateExtended
    Public Const ACTEX_FLAG_WAIT_EXTENDED As Integer = &H100 ' waits longer for device-answer in GSV86activateExtended
    Public Const ACTEX_FLAG_STOP_TX As Integer = &H200 ' stops continious data transmission in GSV86activateExtended

    '/* Constants for GSV86getLastProtocollError and GSV86getLastErrorText */
    Public Const ERRTEXT_SIZE As Integer = 256 ' Maximum size of error text
    Public Const ERR_MASK_ALL As UInteger = &HFC000000UI ' Mask for error code types
    Public Const OWN_ERR_MASK As Integer = &H20000000 'Mask, which can be or-ed with one of the well-known Windows Systen Error Code , see: MSDN:GetLastError()
    Public Const ERR_MSK_DEVICE As Integer = &H38000000 'Error given by GSV-8 device, errorcode in Bits<7:0>, see GSV-8 manual
    '/* This application Errorcodes. Retrieve with GSV86getLastProtocollError. See file Errorcodes.h */

    '/* Hardware properties of GSV-8 device */
    Public Const IN_CHAN_NO As Integer = 8 ' Number of analogue input channels
    Public Const SIX_AXIS_CHAN_NUM As Integer = 6 ' Number of channels of the six-axis sensor
    Public Const NUM_INTYPES As Integer = 6 ' Number of switchable input types

    '/* Object Mapping, as for GSV86getValObjectInfo */
    Public Const VALOBJ_NUM_MAX As Integer = 16 ' Arraysize for ScaleFactors and ObjMapping
    '/* 1. Value type in  Bits<15:8> of ObjMapping */
    Public Const VALTYPE_NORMAL As Integer = 0 ' actual measuring value
    Public Const VALTYPE_MAXVAL As Integer = 1 ' Maximum value
    Public Const VALTYPE_MINVAL As Integer = 2 ' Minimum value
    '/* 2. Physical type in Bits<23:16> of ObjMapping */
    Public Const VAL_PHYS_TYPE_NOTDEF As Integer = 0 ' no physical type defined (unknown)
    Public Const VAL_PHYS_TYPE_FORCE_X As Integer = 1 ' Force in X-direction
    Public Const VAL_PHYS_TYPE_FORCE_Y As Integer = 2 ' Force in Y-direction
    Public Const VAL_PHYS_TYPE_FORCE_Z As Integer = 3 ' Force in Z-direction
    Public Const VAL_PHYS_TYPE_TORQUE_X As Integer = 4 ' Torque-moment in X-direction
    Public Const VAL_PHYS_TYPE_TORQUE_Y As Integer = 5 ' Torque-moment in Y-direction
    Public Const VAL_PHYS_TYPE_TORQUE_Z As Integer = 6 ' Torque-moment in Z-direction
    Public Const VAL_PHYS_TYPE_RAW As Integer = &H10 ' Raw value of six-axis sensor (before calculation)
    Public Const VAL_PHYS_TYPE_TEMP As Integer = &H20 ' Temperature

    ' here is normally the struct, now it's on top in extra class

    '/* 3. DataType enumeration definition for GSV86getValObjectInfo,GSV86getInterfaceIdent, GSV86setValDataType parameter */
    Public Const DATATYP_INT16 As Integer = 1 ' Datatype sent by GSV-8 is 16-Bit value in binary offset format
    Public Const DATATYP_INT24 As Integer = 2 ' Datatype sent by GSV-8 is 24-Bit value in binary offset format
    Public Const DATATYP_FLOAT As Integer = 3 ' Datatype sent by GSV-8 is 32-Bit Float (scaled in physical units)

    '/* Parameter of GSV86getInterfaceIdentity */
    Public Const SET_STOP_MV_TX As Integer = 1 ' StopPermTX parameter: Disable permanent measuring value transmission
    Public Const SET_START_MV_TX As Integer = 2 ' StopPermTX parameter: Enable permanent measuring value transmission

    '/* Constants for GSV86getMode and GSV86setMode Flag-Parameter Mode*/
    Public Const SIX_AXIS_SENSOR_ACTIVE As Integer = &H1 ' Six-axis sensor (=FT-sensor) calculation enabled
    Public Const ANALOG_FILTER_AUTO As Integer = &H2 ' Analog input filter's cut-off frequency set automatically according to data rate
    Public Const MODE_MAXIMUM As Integer = &H4 ' determine maximum- and minimum value
    Public Const MODE_NOISECUT As Integer = &H8 ' if =1: values below noiseCutThreshold are set to 0
    Public Const ALL_WRITES_BLOCKED As Integer = &H80 ' all write / set commands are blocked

    '/* Constants for GSV86getTXmode and GSV86setTXmode Flag-Parameter*/
    Public Const TX_OFF_VOLATILE As Integer = &H1 ' permanent measured value transmission actually off (not stored in EEPROM)
    Public Const TX_OFF_NONVOLAT As Integer = &H2 ' permanent measured value transmission permanent off (stored in EEPROM)
    Public Const TX_MAXVALUE As Integer = &H4 ' values in measured vals frame are maximum values
    Public Const TX_MINVALUE As Integer = &H8 ' values in measured vals frame are minimum values
    Public Const THRESH_VALTYPE_FLOAT As Integer = &H10 ' values for noiseCutThreshold and DoutThreshold are stored as float

    '/*Type enums (constants) for GSV86readFTsensorCalValue */
    Public Const SENSORCAL_TYP_SERNO As Integer = 0 ' Sensor serial number. Type-exeption: u32 not float!
    Public Const SENSORCAL_TYP_MATRIX_NORM As Integer = 1 ' scaling of values in matrix (=1 for normalized matrix values)
    Public Const SENSORCAL_TYP_MATRIX As Integer = 2 ' 6-axis sensor coefficients 6x6 =36 matrix
    Public Const SENSORCAL_TYP_OFFSET As Integer = 3 ' mechanical offsets, 3 values Lx,Ly,Lz
    Public Const SENSORCAL_TYP_MAXVAL As Integer = 4 ' sensor nominal maximum values, 6vals Fx,Fy,Fz,Mx,My,Mz
    Public Const SENSORCAL_TYP_INSENS As Integer = 5 ' Input sensitivity of amp wich matrix vals were obtained (=1 for normalized matrix values)
    Public Const SENSORCAL_TYP_ZEROVAL As Integer = 6 ' Zero signal values of unloaded sensor
    Public Const SENSORCAL_MATRIX_NORM_DEF As Double = 5.0 ' default value for SENSORCAL_TYP_MATRIX_NORM
    Public Const SENSORCAL_INSENS_DEF As Double = 2.0 ' default value for SENSORCAL_TYP_INSENS
    Public Const SENSORCAL_ZEROVAL_DEF As Double = 0.0 ' default value for SENSORCAL_TYP_ZEROVAL
    Public Const SENSORCAL_OFFSET_DEF As Integer = 0 ' default value for SENSORCAL_TYP_OFFSET
    Public Const SENSORCAL_TYP_TEDS_MEM As Integer = &H80 'Memory type-offset for TEDS memory (reserved)
    Public Const SENSORCAL_TYP_EEPROM_MEM As Integer = 0 'Memory type-offset for EEPROM memory
    Public Const SENSORCAL_VECTOR_SIZE As Integer = 6
    Public Const SENSORCAL_MATRIX_SIZE As Integer = 36
    Public Const SENSORCAL_OFFSET_SIZE As Integer = 3
    Public Const SENSORCAL_MAXVAL_SIZE As Integer = 6

    '/*serial number constants */
    Public Const SER_NO_SIZE As Integer = 8
    '#define SER_NO_CHAR_SIZE SER_NO_SIZE+1	'/*inclusive termination */
    Public Const SERNO_MIN As Integer = 1
    Public Const SERNO_MAX As Integer = 99999999

    '/* Constants for GSV86getInTypeRange, GSV86getAllInTypesRanges and GSV86setInType */
    Public Const MAX_INPUT_TYPES_NUM As Integer = 10 '/* Maximum possible number of input types.
    ' (bigger than max. existent type-num, for future compatibiliy) */
    Public Const INTYP_BRIDGE_US875 As Integer = 0 ' Input-Type Bridge at Vexcitation= 8.75V
    Public Const INTYP_BRIDGE_US5 As Integer = 1 ' Input-Type Bridge at Vexcitation= 5V
    Public Const INTYP_BRIDGE_US25 As Integer = 2 ' Input-Type Bridge at Vexcitation= 2.5V
    Public Const INTYP_SE10 As Integer = 3 ' Input-Type single-endend +-10V
    Public Const INTYP_PT1000 As Integer = 4 ' Input-Type Temperature-Sensor PT1000
    Public Const INTYP_TEMP_K As Integer = 5 ' Input-Type Temperature-Sensor Type-K (reserved)


    '/* Constants for GSV86getUnitText and GSV86setUnitText */
    Public Const UNIT_WIDTH As Integer = 8 ' maximum width of unit text array incl. termination
    '/* Bits<7:0> of Code parameter. Can be ORed with Bit<23:8> constants */
    Public Const ACTIVE_UNIT_ANY As Integer = &H0 'GSV86getUnitText: Read active unit. GSV86setUnitText: Set and activate any unit
    Public Const USER_UNIT_1 As Integer = &H1 '/*GSV86getUnitText: Read user defined unit string 1. 
    ' GSV86setUnitText: Set And activate user defined unit String 1. */
    Public Const USER_UNIT_2 As Integer = &H2 '/*GSV86getUnitText: Read user defined unit string 2. 
    ' GSV86setUnitText: Set And activate user defined unit String 2. */
    Public Const SET_FIXED_UNIT As Integer = &H10 'GSV86setUnitText: Set and activate fixed unit (UnitNo set)

    Public Const WRITE_USER_UNIT_1 As Integer = &H11 'GSV86setUnitText: Write user unit string 1 (not activated)
    Public Const WRITE_USER_UNIT_2 As Integer = &H12 'GSV86setUnitText: Write user unit string 2 (not activated)
    ' /* Bits<230> of Code parameter. Can be ORed with Bit<7:0> constants */
    Public Const ANSI_CODEPAGE As Integer = &H0 ' ANSI 8-Bit coded
    Public Const ASCII_ONLY As Integer = &H100 ' Use ASCII 7-Bit only
    Public Const DOS_CODEPAGE_437 As Integer = &H1B500 ' DOS/Windows Codepage 437
    Public Const WIN_CODEPAGE_1252 As Integer = &H4E400 ' Windows Codepage 1252

    '/* Constants for digital filters GSV86getDfilterOnOff and GSV86setDfilterOnOff */
    Public Const FILT_TYPE_IIR As Integer = 0 ' Mask or for IIR-Type.
    Public Const FILT_TYPE_FIR As Integer = &H80 ' Mask or for FIR-Type. See function description for details
    Public Const FILT_TYPE_IIR_LP As Integer = &H4 ' IIR low pass, 4th order
    Public Const FILT_TYPE_IIR_HP As Integer = &H14 ' IIR high pass, 4th order
    Public Const FILT_TYPE_IIR_BP As Integer = &H24 ' IIR band pass, 4th order
    Public Const FILT_TYPE_IIR_BS As Integer = &H34 ' IIR band stop, 4th order
    Public Const FILT_TYPE_UNCONFIG As Integer = &H0 ' Filter has nor been configured
    Public Const FILT_ORDER_MSK As Integer = &HF ' Mask for filter order
    Public Const FILT_ORDER_IIR As Integer = 4 ' As by now, filter order is constant for IIR filter
    Public Const FILT_MAXORDER_FIR As Integer = 14 ' Maximum FIR filter Order
    Public Const FILT_MINORDER_FIR As Integer = 4 ' Minimum FIR filter Order
    Public Const FILT_COEFFNUM_FIR As Integer = 8 ' Because a0=a7, a1=a6... coeff. number is order/2
    Public Const FILT_CHARACT_MSK As Integer = &H70 ' Mask for filter characteristic (LP,HP,BP,BS)
    Public Const FILT_CHARACT_LP As Integer = &H0 ' low pass
    Public Const FILT_CHARACT_HP As Integer = &H10 ' high pass
    Public Const FILT_CHARACT_BP As Integer = &H20 ' band pass
    Public Const FILT_CHARACT_BS As Integer = &H30 ' band stop
    Public Const FILT_CHARACT_COMB As Integer = &H40 ' comb filter (FIR only)
    Public Const FILT_IDX_MSK_B_COEFF As Integer = &H10 'Mask for IIR index parameter for b coefficients
    Public Const FILT_FCUT_RATIO_MAX As Single = 0.5F ' maximum ratio for Fcutoff/Fs
    ' /* Constants for GSV86simulateDfilter. May be ORed with FILT_TYPE_FIR */
    Public Const SIMUL_DFILT_FREQ_RESPONSE As Integer = 1 ' simulate frequency response (frequency domain)
    Public Const SIMUL_DFILT_STEP_RESPONSE As Integer = 2 ' simulate step response (time domain)

    '/* Constants for analogue filter */
    Public Const FDATA_MAX_FG28HZ As Integer = 80 ' With SetAnalogFilterAuto: Below this data rate filter is set to 28Hz cutoff
    Public Const FDATA_MAX_FG1KHZ As Integer = 3000 ' With SetAnalogFilterAuto: Below this data rate filter is set to 850Hz cutoff
    Public Const ANAFILT_LOW As Integer = 28 ' lowest cut-off frequency of analogue input filter (switchable)
    Public Const ANAFILT_MID As Integer = 850 ' middle cut-off frequency of analogue input filter (switchable)
    Public Const ANAFILT_HIGH As Integer = 12000 ' highest cut-off frequency of analogue input filter (fixed)

    '/* Constants for analog output */
    Public Const AOUT_TYPE_0_10V As Integer = 0 ' 0..10V
    Public Const AOUT_TYPE_10_10V As Integer = 1 ' -10..10V
    Public Const AOUT_TYPE_0_5V As Integer = 2 ' 0..5V
    Public Const AOUT_TYPE_5_5V As Integer = 3 ' -5..5V
    Public Const AOUT_TYPE_4_20A As Integer = 4 ' 4..20mA
    Public Const AOUT_TYPE_0_20A As Integer = 6 ' 0..20mA
    '/* Mode: Flag value as follows: */

    Public Const AOUT_ACTIVE_M_VALUES As Integer = 0 ' Output is on and follows the corresponding measuring value input.
    Public Const AOUT_MODE_DIRECT As Integer = 1 '/*Output is on, but does NOT react on measuring values,
    '	but Is direcly settable with GSV86writeAoutDirect */

    Public Const AOUT_MODE_OFF As Integer = 2 ' Output is off and high-impedance.
    Public Const AOUT_IX_MAX As Integer = 8 ' 8 Analogue Voltage/current outputs.
    Public Const AOUT_SCALE_IX_MAX As Integer = 9 ' No. 9 for special-version (freq. output)

    '/* Constants for GSV86getEquipment */
    Public Const HAS_ADC As Integer = &H1
    Public Const HAS_ETHERCAT As Integer = &H2
    Public Const HAS_LCD As Integer = &H4
    Public Const HAS_TEDS As Integer = &H8
    Public Const HAS_DIGI_IO As Integer = &H10
    Public Const HAS_ANALOG_OUT As Integer = &H40
    Public Const HAS_SERIAL As Integer = &H80
    Public Const HAS_FREQ_OUT As Integer = &H100
    Public Const HAS_AIN_MCU As Integer = &H200
    Public Const HAS_SIXAXIS As Integer = &H400
    Public Const HAS_CANOPEN As Integer = &H800

    ' Constants for DIOtype
    Public Const DIO_IN_GENERALPURPOSE As Integer = &H4
    Public Const DIO_IN_SYNC_SLAVE As Integer = &H2
    Public Const DIO_IN_QEI_ANY As Integer = &H8
    Public Const DIO_IN_TARE_SINGLE As Integer = &H10
    Public Const DIO_IN_TARE_ALL As Integer = &H20
    Public Const DIO_IN_RESET_MAXMIN As Integer = &H40
    Public Const DIO_IN_TRIG_SEND_VAL As Integer = &H80
    Public Const DIO_IN_TRIG_SEND_MAXVAL As Integer = &H100
    Public Const DIO_IN_TRIG_SEND_MINVAL As Integer = &H200
    Public Const DIO_IN_TRIG_SEND_AVGVAL As Integer = &H400
    Public Const DIO_IN_TRIG_SEND_VAL_WHILE_HI As Integer = &H800
    Public Const DIO_OUT_GENERALPURPOSE As Integer = &H1000
    Public Const DIO_THRESHOLD_WINDOWCOMP_MASK As Integer = &H2000
    Public Const DIO_OUT_THRESHOLD_MAXVAL As Integer = &H14000
    Public Const DIO_OUT_THRESHOLD_MINVAL As Integer = &H18000
    Public Const DIO_OUT_THRESHOLD_ANYVAL As Integer = &H10000
    Public Const DIO_OUT_SYNC_MASTER As Integer = &H20000
    Public Const DIO_INVERT_MASK As Integer = &H800000

    ' Constants for GSV86readCANsettings / GSV86setCANsettings
    Public Const CAN_SER_CMD_ID As Integer = 0
    Public Const CAN_SER_ANSW_ID As Integer = 1
    Public Const CAN_SER_MV_ID As Integer = 2
    Public Const CAN_SER_MULTI_ID As Integer = 3
    Public Const CAN_BAUDRATE As Integer = 4
    Public Const CAN_FLAGS As Integer = 5
    Public Const CANOPEN_NODEID As Integer = 6
    Public Const CAN_FLAGMASK_ONOFF As Integer = 1
    Public Const CAN_FLAGVAL_ON As Integer = 0
    Public Const CAN_FLAGVAL_OFF As Integer = 1
    Public Const CAN_FLAGMASK_PROT As Integer = 2
    Public Const CAN_FLAGVAL_CANOPEN As Integer = 2
    Public Const CAN_FLAGVAL_CANSER As Integer = 0

    '  /* Constant macros for use with Communication interface descriptor functions
    ' GSV86readInterfaceSetting
    ' GSV86writeInterfaceSetting
    ' GSV86readBasicInterfSettings
    ' GSV86readAllInterfSettings */
    ' /* Interface Physical Layer protocol enumeration */

    Public Const INTF_PHY_TYP_V24 As Integer = 1 ' RS232 with V24 voltage levels
    Public Const INTF_PHY_TYP_232TTL As Integer = 2 ' RS232 with 3.3V / 0V voltage levels
    Public Const INTF_PHY_TYP_USB As Integer = 3 ' USB (with CDC)
    Public Const INTF_PHY_TYP_CAN As Integer = 4 ' CAN bus
    Public Const INTF_PHY_TYP_ETH As Integer = 5 ' 100BaseT "Ethernet"
    ' /* Interface Application Layer protocol enumeration */
    Public Const INTF_APP_TYP_GSV68 As Long = &H1 ' ME propretary "GSV6/8" interface, used by this DLL
    Public Const INTF_APP_TYP_CANOPEN As Long = &H2 ' CANopen
    Public Const INTF_APP_TYP_ETCOE As Long = &H3 ' EtherCAT CoE
    Public Const INTF_APP_TYP_MONI As Long = &H4 ' Text-based commands "Monitor", GSV-6 only
    ' /* The flags-value of basic interface setting */
    Public Const INTF_T1_FLG_ACT As Integer = 1 ' Flag (-mask) indicating that interface is enabled
    Public Const INTF_T1_FLG_RXACT As Integer = 1 ' Flag (-mask) indicating that receiving commands is enabled
    Public Const INTF_T1_FLG_TXACT As Integer = 2 ' Flag (-mask) indicating that transmitting data is enabled
    Public Const INTF_T1_FLG_TXRX_ACT As Integer = 3 ' Flag (-mask) indicating that transmit and receive is enabled
    Public Const INTF_T1_FLG_WRACC As Integer = 4 ' Flag (-mask) indicating that write commands are allowed
    Public Const INTF_T1_MV_BINOFS As Integer = 8 ' Flag (-mask) indicating that integer measuring values have binary offset formal (sign bit inverted)
    Public Const INTF_T1_FLG_SWITCHABLE As Integer = &H10000 ' Flag (-mask) indicating that interface can be disabled (then enabled)
    Public Const INTF_T1_FLG_ADRESSABLE As Integer = &H20000 ' Flag (-mask) indicating that interface uses device or service address/ID
    Public Const INTF_T1_FLG_ADRES_CHANGE As Integer = &H40000 ' Flag (-mask) indicating that device / service address/ID can be changes by command interface
    '/* Data/Setting type 2 meaning enumeration */
    Public Const INTF_DSCTYP_FLAGS As Integer = 0 ' Flag value of basic interface setting
    Public Const INTF_DSCTYP_FLG_SETMSK As Integer = 1 ' Mask for setting a bit in the Flag value of the basic setting =1:Flag at this pos. can be set
    Public Const INTF_DSCTYP_FLG_CLRMSK As Integer = 2 ' Mask for clearing a bit in the Flag value of the basic setting =1:Flag at this pos. can be cleared
    Public Const INTF_DSCTYP_MUTEXCLUSIV As Integer = 3 ' Ordinal number of other interfaces, that this exist in a mutual exclusive manner. Upto 4 in 4 Bytes, beginning with LSByte
    Public Const INTF_DSCTYP_ACTBAUD As Integer = 4 ' Baud Rate actually set, in Bits/s
    Public Const INTF_DSCTYP_BAUD_AVAIL As Integer = 5 ' Baud rate existent, in Bits/s
    Public Const INTF_DSCTYP_NUM_SERVID As Integer = 6 ' Number of IDs of device or servicve, used with field bus interfaces
    Public Const INTF_DSCTYP_SERVID_CAN_IN As Integer = 7 ' CAN-ID for Host->Device commands, used with "GSV68 CAN-serial"
    Public Const INTF_DSCTYP_SERVID_CAN_OUT As Integer = 8 ' CAN-ID for Device->Host command answers, used with "GSV68 CAN-serial"
    Public Const INTF_DSCTYP_SERVID_CAN_CV As Integer = 9 ' CAN-ID for Device->Host measuring value frames, used with "GSV68 CAN-serial"
    Public Const INTF_DSCTYP_SERVID_CAN_CAST As Integer = 10 ' CAN-ID for Host->Devices multicast messages, used with "GSV68 CAN-serial"
    Public Const INTF_DSCTYP_SERVID_CANO_NODE As Integer = 11 ' CANopen Node-ID, used with CANopen aplication protocol
    Public Const INTF_DSCTYP_DEVSTATE As Integer = 16 ' Device state, used with fieldbus application protocols
    Public Const INTF_FB_STAT_OFF As Integer = 0 ' Data-value for INTF_DSCTYP_DEVSTATE if Interface is off
    Public Const INTF_FB_STAT_INIT As Integer = 2 ' Data-value for INTF_DSCTYP_DEVSTATE if device is in init or stopped state
    Public Const INTF_FB_STAT_PO As Integer = 4 ' Data-value for INTF_DSCTYP_DEVSTATE if device is in pre-operational state
    Public Const INTF_FB_STAT_SO As Integer = 8 ' Data-value for INTF_DSCTYP_DEVSTATE if device is in safe operational state (EtherCAT)
    Public Const INTF_FB_STAT_O As Integer = 12 ' Data-value for INTF_DSCTYP_DEVSTATE if device is in operational state
    Public Const INTF_DSCTYP_CANO_TX_TIME As Integer = 17 ' CANopen Transmission Type (Bits<31:24>) and Event timer (Bits<15:0>)
    Public Const INTF_DSCTYP_CANO_INH_HB As Integer = 18 ' CANopen Inhibit time (Bits<31:16>) and Heartbeat time (Bits<15:0>)
    Public Const INTFT2_WR As Integer = &H80 ' Flag value indicating that a value is writable. ORed with data type enum
    Public Declare Function GSV86dllVersion Lib "MEGSV86x64" () As Integer

    Public Declare Function GSV86actExt Lib "MEGSV86x64" (ByVal ComNo As Integer) As Integer
    Public Declare Function GSV86activateExtended Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Bitrate As UInteger, ByVal BufSize As UInteger, ByVal flags As UInteger) As Integer
    Public Declare Function GSV86getLastProtocollError Lib "MEGSV86x64" (ByVal ComNo As Integer) As Integer 'http://msdn.microsoft.com/en-us/library/ms681381(VS.85).aspx
    Public Declare Function GSV86getLastErrorText Lib "MEGSV86x64" (ByVal ComNo As Integer, ByRef ErrText As String) As Integer
    Public Declare Function GSV86clearDLLbuffer Lib "MEGSV86x64" (ByVal ComNo As Integer) As Integer
    Public Declare Function GSV86getInterfaceIdentity Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal StopPermTX As Integer, ByRef NumOfIntfDescr As Integer, ByRef ThisInterfNo As Integer, ByRef WriteProtect As Integer, ByRef MValDataType As Integer, ByRef MValPermanenTX As Integer, ByRef NumObjInMVframe As Integer, ByRef ThisDeviceModel As Integer, ByRef ThisProtocol As Integer) As Integer

    Public Declare Function GSV86clearDeviceBuf Lib "MEGSV86x64" (ByVal ComNo As Integer) As Integer
    Public Declare Function GSV86received Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer) As Integer
    Public Declare Function GSV86read Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByRef out As Double) As Integer
    Public Declare Function GSV86readMultiple Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByRef out As Double, ByVal count As Integer, ByRef valsread As Integer, ByRef ErrFlags As Integer) As Integer
    Public Declare Function GSV86startTX Lib "MEGSV86x64" (ByVal ComNo As Integer) As Integer
    Public Declare Function GSV86stopTX Lib "MEGSV86x64" (ByVal ComNo As Integer) As Integer
    Public Declare Function GSV86release Lib "MEGSV86x64" (ByVal ComNo As Integer) As Integer
    Public Declare Function GSV86getSerialNo Lib "MEGSV86x64" (ByVal ComNo As Integer) As Integer
    Public Declare Function GSV86getTXmode Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Index As Integer) As Integer
    Public Declare Function GSV86setTXmode Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Index As Integer, ByVal TXmode As UInteger) As Integer
    Public Declare Function GSV86isValTXpermanent Lib "MEGSV86x64" (ByVal ComNo As Integer) As Integer
    Public Declare Function GSV86getWriteAccess Lib "MEGSV86x64" (ByVal ComNo As Integer) As Integer
    Public Declare Function GSV86setValDataType Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Datatype As Integer) As Integer
    Public Declare Function GSV86firmwareVersion Lib "MEGSV86x64" (ByVal ComNo As Integer) As Integer
    Public Declare Function GSV86readUserScale Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByRef Norm As Double) As Integer
    Public Declare Function GSV86writeUserScale Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByVal Norm As Double) As Integer
    Public Declare Function GSV86getMode Lib "MEGSV86x64" (ByVal ComNo As Integer) As Integer
    Public Declare Function GSV86setMode Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Mode As UInteger) As Integer
    Public Declare Function GSV86getFTsensorActive Lib "MEGSV86x64" (ByVal ComNo As Integer) As Integer
    Public Declare Function GSV86setFTsensorActive Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal OnOff As Integer) As Integer
    Public Declare Function GSV86getModeAfilterAuto Lib "MEGSV86x64" (ByVal ComNo As Integer) As Integer
    Public Declare Function GSV86setModeAfilterAuto Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal OnOff As Integer) As Integer
    Public Declare Function GSV86getModeNoiseCut Lib "MEGSV86x64" (ByVal ComNo As Integer) As Integer
    Public Declare Function GSV86setModeNoiseCut Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal OnOff As Integer) As Integer
    Public Declare Function GSV86getModeMaxMin Lib "MEGSV86x64" (ByVal ComNo As Integer) As Integer
    Public Declare Function GSV86setModeMaxMin Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal OnOff As Integer) As Integer
    Public Declare Function GSV86getValObjectInfo Lib "MEGSV86x64" (ByVal ComNo As Integer, ByRef ScaleFactors As Double, ByRef ObjMapping As UInteger, ByRef DataType As Integer) As Integer
    Public Declare Function GSV86getValMapping Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Index As Integer) As Integer
    Public Declare Function GSV86setValMapping Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Index As Integer, ByVal ObjMapping As UInteger) As Integer
    Public Declare Function GSV86setFTarrayToRead Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal ArrNo As Integer) As Integer
    Public Declare Function GSV86readFTsensorCalValue Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal typ As Integer, ByVal ix As Integer, ByRef val As Double) As Integer
    Public Declare Function GSV86readFTsensorCalArray Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal ArrNo As Integer, ByRef SensorSerNo As String, ByRef MatrixNorm As Double, ByRef InSens As Double, ByRef Matrix As Double, ByRef Offsets As Double, ByRef MaxVals As Double, ByRef Zvals As Double) As Integer
    Public Declare Function GSV86writeFTsensorCalArray Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal ArrNo As Integer, ByVal SensorSerNo As String, ByVal MatrixNorm As Double, ByVal InSens As Double, ByRef Matrix As Double, ByRef Offsets As Double, ByRef MaxVals As Double, ByRef Zvals As Double) As Integer
    Public Declare Function GSV86writeFTsensorGeoOffsets Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal ArrNo As Integer, ByRef offsets As Double) As Integer
    Public Declare Function GSV86readFTsensorSerNo Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal ArrNo As Integer, ByRef SensorSerNo As String) As Integer
    Public Declare Function GSV86writeFTsensorFromFile Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal ArrNo As Integer, ByVal DatFilePath As String) As Integer
    Public Declare Function GSV86getFTsensorCalArrayInfo Lib "MEGSV86x64" (ByVal ComNo As Integer, ByRef MaxNumSupp As Integer, ByRef ArrNumStored As Integer) As Integer
    Public Declare Function GSV86setFTsensorActiveCalArray Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal ArrNo As Integer) As Integer
    Public Declare Function GSV86eraseFTsensorCalArray Lib "MEGSV86x64" (ByVal ComNo As Integer) As Integer
    Public Declare Function GSV86getFrequency Lib "MEGSV86x64" (ByVal ComNo As Integer) As Double
    Public Declare Function GSV86setFrequency Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal frequency As Double) As Integer
    Public Declare Function GSV86setZero Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer) As Integer
    Public Declare Function GSV86getInTypeRange Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByRef Range As Double) As Integer
    Public Declare Function GSV86getAllInTypesRanges Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByRef InTypes As Integer, ByRef Ranges As Double) As Integer
    Public Declare Function GSV86setInType Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByVal InType As Integer) As Integer
    Public Declare Function GSV86readUserOffset Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByRef Offset As Double) As Integer
    Public Declare Function GSV86writeUserOffset Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByVal Offset As Double) As Integer
    Public Declare Function GSV86loadSettings Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal DataSetNo As Integer) As Integer
    Public Declare Function GSV86storeSettings Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal DataSetNo As Integer) As Integer
    Public Declare Function GSV86getAnalogOutType Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByRef Type As Integer) As Integer
    Public Declare Function GSV86setAnalogOutType Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByVal Type As Integer, ByVal Mode As Integer) As Integer
    Public Declare Function GSV86writeAnalogOutOffset Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByVal Offset As Double) As Integer
    Public Declare Function GSV86readAnalogOutOffset Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByRef Offset As Double) As Integer
    Public Declare Function GSV86readAnalogOutScale Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByRef Scale As Double) As Integer
    Public Declare Function GSV86writeAnalogOutScale Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByVal Scale As Double) As Integer
    Public Declare Function GSV86writeAoutDirect Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByVal Code As Integer) As Integer
    Public Declare Function GSV86getUnitNo Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer) As Integer
    Public Declare Function GSV86setUnitNo Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByVal UnitNo As Integer) As Integer

    '/* Constants for GSV86getUnitText and GSV86setUnitText */
    Public Const UNIT_WIDTH As Integer = 8 ' maximum width of unit text array incl. termination
    '/* Bits<7:0> of Code parameter. Can be ORed with Bit<23:8> constants */
    Public Const ACTIVE_UNIT_ANY As Integer = &H0 'GSV86getUnitText: Read active unit. GSV86setUnitText: Set and activate any unit
    Public Const USER_UNIT_1 As Integer = &H1 '/*GSV86getUnitText: Read user defined unit string 1. 
    ' GSV86setUnitText: Set And activate user defined unit String 1. */
    Public Const USER_UNIT_2 As Integer = &H2 '/*GSV86getUnitText: Read user defined unit string 2. 
    ' GSV86setUnitText: Set And activate user defined unit String 2. */
    Public Const SET_FIXED_UNIT As Integer = &H10 'GSV86setUnitText: Set and activate fixed unit (UnitNo set)
    Public Const WRITE_USER_UNIT_1 As Integer = &H11 'GSV86setUnitText: Write user unit string 1 (not activated)
    Public Const WRITE_USER_UNIT_2 As Integer = &H12 'GSV86setUnitText: Write user unit string 2 (not activated)
    ' /* Bits<230> of Code parameter. Can be ORed with Bit<7:0> constants */
    Public Const ANSI_CODEPAGE As Integer = &H0 ' ANSI 8-Bit coded
    Public Const ASCII_ONLY As Integer = &H100 ' Use ASCII 7-Bit only
    Public Const DOS_CODEPAGE_437 As Integer = &H1B500 ' DOS/Windows Codepage 437
    Public Const WIN_CODEPAGE_1252 As Integer = &H4E400 ' Windows Codepage 1252

    Public Declare Function GSV86getUnitText Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByVal Code As Integer, ByRef UnitText As String) As Integer
    Public Declare Function GSV86setUnitText Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByVal Code As Integer, ByRef UnitText As String) As Integer
    Public Declare Function GSV86getDfilterOnOff Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByVal Type As Integer) As Integer
    Public Declare Function GSV86setDfilterOnOff Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByVal Type As Integer, ByVal OnOff As Integer) As Integer
    Public Declare Function GSV86getDfilterInfo Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByVal TypeIn As Integer, ByRef TypeOut As Integer, ByRef CutOff As Double) As Integer
    Public Declare Function GSV86getDfilterType Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByVal TypeIn As Integer) As Integer
    Public Declare Function GSV86getDfilterCoeff Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByVal Type As Integer, ByRef Coeff As Double, ByRef CoeffB As Double) As Integer
    Public Declare Function GSV86setDfilterParams Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByVal Type As Integer, ByRef CutRatio As Double, ByRef Coeff As Double, ByRef CoeffB As Double) As Integer
    Public Declare Function GSV86calcSetDfilterParams Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByVal Type As Integer, ByVal CutOff As Double, ByVal CutOffHi As Double) As Integer
    Public Declare Function GSV86simulateDfilter Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Analyze_Ftyp As Integer, ByVal StartVal As Double, ByVal EndVal As Double, ByVal Fa As Double, ByVal Points As Integer, ByRef Filepath As String) As Integer
    Public Declare Function GSV86readDeviceHours Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Index As Integer) As Double
    Public Declare Function GSV86writeDeviceHours Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Hours As Double) As Integer
    Public Declare Function GSV86getNoiseCutThreshold Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByRef Thres As Double) As Integer
    Public Declare Function GSV86setNoiseCutThreshold Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByVal Thres As Double) As Integer
    Public Declare Function GSV86getSoftwareConfiguration Lib "MEGSV86x64" (ByVal ComNo As Integer) As Integer
    Public Declare Function GSV86setMeasValProperty Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal PropType As Integer) As Integer
    Public Declare Function GSV86getValueError Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Ix As Integer, ByRef ErrInfo As Integer, ByRef ErrTime As Double) As Integer
    Public Declare Function GSV86eraseValueErrMemory Lib "MEGSV86x64" (ByVal ComNo As Integer) As Integer
    Public Declare Function GSV86resetErrorState Lib "MEGSV86x64" (ByVal ComNo As Integer) As Integer
    Public Declare Function GSV86readAnalogFilterCutOff Lib "MEGSV86x64" (ByVal ComNo As Integer, ByRef CutOffFreq As Double) As Integer
    Public Declare Function GSV86writeAnalogFilterCutOff Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal CutOffFreq As Double) As Integer
    Public Declare Function GSV86readZeroValue Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer) As Integer
    Public Declare Function GSV86writeZeroValue Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByVal zero As Integer) As Integer
    Public Declare Function GSV86getIDlevel Lib "MEGSV86x64" (ByVal ComNo As Integer) As Integer
    Public Declare Function GSV86triggerValue Lib "MEGSV86x64" (ByVal ComNo As Integer) As Integer
    Public Declare Function GSV86getMaxMinValue Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByRef MaxValue As Double, ByRef MinValue As Double) As Integer
    Public Declare Function GSV86clearMaxMinValue Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer) As Integer
    Public Declare Function GSV86getIsCmdAvailable Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal CmdUp As Integer, ByVal CmdLo As Integer) As Integer
    Public Declare Function GSV86switchBlocking Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal OnOff As Integer) As Integer
    Public Declare Function GSV86changePassword Lib "MEGSV86x64" (ByVal ComNo As Integer, ByRef NewPW As String) As Integer
    Public Declare Function GSV86setPassword Lib "MEGSV86x64" (ByVal ComNo As Integer, ByRef password As String) As Integer
    Public Declare Function GSV86getDIOdirection Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal DIOgroup As Integer) As Integer
    Public Declare Function GSV86setDIOdirection Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal DIOgroup As Integer, ByVal Direction As Integer) As Integer
    Public Declare Function GSV86getDIOtype Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal DIOno As Integer, ByRef AssignedChan As Integer) As Integer
    Public Declare Function GSV86setDIOtype Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal DIOno As Integer, ByVal DIOtype As Integer, ByVal AssignedChan As Integer) As Integer
    Public Declare Function GSV86getDIOlevel Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal DIOno As Integer) As Integer
    Public Declare Function GSV86setDoutLevel Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal DIOno As Integer, ByVal DIOlevel As Integer) As Integer
    Public Declare Function GSV86getDoutThreshold Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal DIOno As Integer, ByRef ThresUp As Double, ByRef ThresDown As Double) As Integer
    Public Declare Function GSV86setDoutThreshold Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal DIOno As Integer, ByVal ThresUp As Double, ByVal ThresDown As Double) As Integer
    Public Declare Function GSV86getDoutInitLevel Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal DIOno As Integer) As Integer
    Public Declare Function GSV86setDoutInitLevel Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal DIOno As Integer, ByVal DOInitLevel As Integer) As Integer
    Public Declare Function GSV86getDataRateRange Lib "MEGSV86x64" (ByVal ComNo As Integer, ByRef DrateMax As Double, ByRef DrateMin As Double) As Integer
    Public Declare Function GSV86readCANsettings Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Index As Integer, ByRef setting As Integer) As Integer
    Public Declare Function GSV86setCANsettings Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Index As Integer, ByVal setting As Integer) As Integer
    Public Declare Function GSV86getCANonOff Lib "MEGSV86x64" (ByVal ComNo As Integer, ByRef CANappProt As Integer) As Integer
    Public Declare Function GSV86setCANonOff Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal OnOff As Integer) As Integer
    ' Public Declare Function GSV86readInterfaceSetting Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Ix As Integer, ByRef @Next As Integer, ByRef Data As UInteger, ByRef ApplEnum As Integer, ByRef Writable As Integer) As Integer
    Public Declare Function GSV86readBasicInterfSettings Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal ActIntf As Integer, ByRef PhysEnums As Integer, ByRef ApplEnums As Integer, ByRef Flags As Integer) As Integer
    Public Declare Function GSV86readAllInterfSettings Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal IntNo As Integer, ByRef IntfEnums As Integer, ByRef Dtypes As Integer, ByRef Data As Integer, ByRef BdList As Integer, ByRef BdNum As Integer) As Integer
    Public Declare Function GSV86writeInterfaceSetting Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Ix As Integer, ByVal Data As UInteger) As Integer
    Public Declare Function GSV86setInterfaceOnOff Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal IntNo As Integer, ByVal OnOff As Integer) As Integer
    Public Declare Function GSV86writeInterfaceBaud Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal IntNo As Integer, ByVal Baud As Integer) As Integer
    Public Declare Function GSV86readHWversion Lib "MEGSV86x64" (ByVal ComNo As Integer, ByRef MainHW As Integer, ByRef ExtHW As Integer) As Integer
    Public Const TEDS_ANSW_IS_FLT As Integer = 1
    Public Const TEDS_IS_PACKED_CHR5 As Integer = 2
    Public Const TEDS_IS_DATE_DAYS As Integer = 4
    Public Const TEDS_ENTRY_HAS_ERROR As Integer = &H80
    Public Const TEDS_ENTRY_NOT_EXIST As Integer = &HFF
    Public Const TEDS_ENTRY_NOT_SET As Integer = &HFE
    Public Const TEDS_ENTRY_INVALID As Integer = &HFD
    'Public Declare Function GSV86readTEDSentry Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByVal TemplID As Integer, ByVal PropID As Integer, ByRef @Next As Integer, ByVal No As Integer, ByRef Udata As UInteger, ByRef DblData As Double, ByRef Flags As Integer) As Integer
    Public Const TEDSLISTFLG_BASICONLY As Integer = 1 ' List Basic template only
    Public Const TEDSLISTFLG_MAINONLY As Integer = 2 ' List Main template only
    Public Const TEDSLISTFLG_COLUMN_NUM_VAR As Integer = 4 ' Empty field left away, so that column number is variable
    Public Const TEDSLISTFLG_FILL_EMPTY_SPACE As Integer = 8 ' Insert space in empty field
    Public Const TEDSLISTFLG_PIPE_SEPARA As Integer = 16 'Field separator inside line is | otherwise TAB
    Public Declare Function GSV86readFormattedTEDSList Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByVal TEDSfilePath As String, ByRef ListOut As String, ByVal ListSize As Integer, ByVal Code As Integer, ByRef ExtListOut As String) As Integer
    Public Declare Function GSV86readTEDSrawData Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByRef DataOut As Byte, ByVal NumBytes As Integer, ByVal StartByteAdr As Integer) As Integer
    Public Declare Function GSV86writeTEDSrawData Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByVal DataIn As Byte, ByVal NumBits As Integer, ByVal StartBitAdr As Integer) As Integer
    Public Declare Function GSV86getSensorPlugged Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByRef BridgeSensor As Integer, ByRef TEDScapable As Integer) As Integer
    Public Declare Function GSV86getTEDSactive Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer) As Integer
    Public Declare Function GSV86MEwriteCal Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByVal ix As Integer, ByVal cal As Double) As Integer
    Public Declare Function GSV86readCal Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByVal ix As Integer, ByRef cal As Double) As Integer
    Public Declare Function GSV86MEwriteInputRange Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal Chan As Integer, ByVal type As Integer, ByVal range As Double) As Integer
    Public Declare Function MEgsv86setSerialNo Lib "MEGSV86x64" (ByVal ComNo As Integer, ByVal SerNo As Integer) As Integer
End Class