/*******************************************************************************************
C-Header file with additional constant macros, which for convenience are not defined in MEGSV8xxx.h
Copyright 2014 ME-Messysteme GmbH H.Kabelitz
********************************************************************************************/
/* GSV-8 Commands */
#define CMD_RESET_STATUS 0
#define CMD_GETIDENTITY	1
#define CMD_READ_ZERO		2
#define CMD_WRITE_ZERO		3
#define CMD_READOFFSET		4
#define CMD_WRITEOFFSET		5
#define CMD_READ_ANA_SCALE	6
#define CMD_WRITE_ANA_SCALE	7
#define CMD_SET_AOUT_DIRECT	8
#define CMD_GETALL		9
#define CMD_SAVEALL		0x0a
#define CMD_SETZERO	0x0c
#define CMD_GET_AOUT_TYPE 0x0D
#define CMD_SET_AOUT_TYPE 0x0E
#define CMD_GETUNITNO	0x0f
#define CMD_SETUNITNO	0x10
#define CMD_GETUNITTEXT	0x11
#define CMD_SETUNITTEXT	0x12
#define CMD_GETNORM	0x14
#define CMD_SETNORM	0x15
#define CMD_MEGETCAL	0x17
#define CMD_MESETCAL	0x18
#define CMD_MESETID	0x19
#define CMD_MEGETIDSTATE	0x1a
#define CMD_READ_SENSORMODEL	0x1b
#define CMD_WRITE_SENSORMODEL	0x1c
#define CMD_READ_CAL_OPERATOR	0x1d //neu 1.23
#define CMD_MEWR_CAL_OPERATOR	0x1e
#define CMD_GETSERNO	0x1f
#define CMD_MESETSERNO	0x20
#define CMD_READ_CAL_DATE	0x21 //neu 1.23
#define CMD_MEWR_CAL_DATE	0x22
#define CMD_STOP_TRANSMISSION	0x23
#define CMD_START_TRANSMISSION	0x24
#define CMD_CLEARBUFFERABORTTX	0x25
#define CMD_GETMODE	0x26
#define CMD_SETMODE	0x27
#define CMD_MESETEQUIPMENT	0x29
#define CMD_GETEQUIPMENT	0x2a
#define CMD_FIRMWAREVERSION	0x2b
#define CMD_MEWRITERANGE	0x34
#define CMD_SETVALPROPS	0x35
#define CMD_GETOPTIONS	0x36
#define CMD_GET_RAW_VALUE	0x3a
#define CMD_GETVALUE	0x3b
#define CMD_CLEARMAXIMUM_VALUE	0x3c
#define CMD_GETLASTERROR	0x42
#define CMD_GET_VALUE_ERROR	0x43
#define CMD_ERASE_ERROR_MEMORY	0x44
#define CMD_GET_SENSOR_PLUGGED	0x45
#define CMD_READSENSORCAL	0x47	/* Type=0: SensorSerNo, Type=1: KalMatrix, Type=2: Offset, Type=3: MaxWerte */
#define CMD_WRITESENSORCAL	0x48	/* war 39 */
#define CMD_GET_TXMAPPING	0x49
#define CMD_SET_TXMAPPING	0x4A
#define CMD_GET_DFILT_TYPE	0x4B
#define CMD_SET_DFILT_TYPE	0x4C
#define CMD_GET_DFILT_CUTOFF	0x4D
#define CMD_SET_DFILT_CUTOFF	0x4E
#define CMD_READ_DFILT_COEF	0x4F
#define CMD_WRITE_DFILT_COEF	0x50
#define CMD_GET_DFILT_ONOFF	0x51
#define CMD_SET_DFILT_ONOFF	0x52
#define CMD_GET_MAXMIN_VAL	0x53
#define CMD_GET_FTSENSOR_ARR_NO	0x54
#define CMD_SET_FTSENSOR_ARR_NO	0x55
#define CMD_GET_DEVICEHOURS	0x56
#define CMD_SET_DEVICEHOURS	0x57
#define CMD_CHANGE_PASSWORD	0x58
#define CMD_GET_DIO_DIRECTION	0x59
#define CMD_SET_DIO_DIRECTION	0x5A
#define CMD_GET_DIO_TYPE	0x5B
#define CMD_SET_DIO_TYPE	0x5C
#define CMD_GET_DIO_LEVEL	0x5D
#define CMD_SET_DIO_LEVEL	0x5E
#define CMD_GET_DO_THRES	0x5F
#define CMD_SET_DO_THRES	0x60
#define CMD_GET_DO_INIT_LEV	0x61
#define CMD_SET_DO_INIT_LEV	0x62
#define CMD_GET_DRATE_RANGE	0x63
#define CMD_GET_TEDS_ENTRY	0x64
#define CMD_READ_TEDS_ARRAY	0x65
#define CMD_WRITE_TEDS_DATA	0x66
#define CMD_STORE_TEDS_DATA	0x67
#define CMD_GET_TEDS_ACTIVE	0x68
#define CMD_GET_COUNTER_MODE	0x69
#define CMD_SET_COUNTER_MODE	0x6A
#define CMD_READ_CLOCK_TIME	0x6B
#define CMD_WRITE_CLOCK_TIME	0x6C
#define CMD_READ_LOG_SETTING	0x6D
#define CMD_WRITE_LOG_SETTING	0x6E
#define CMD_CONTROL_LOGGER	0x6F
#define CMD_QUERY_FILE_SYS	0x70
#define CMD_OPEN_FILE_DIR	0x71
#define CMD_GET_FILEINFO	0x72
#define CMD_READ_FILE		0x73
#define CMD_READ_FILE_EX	0x74
#define CMD_READ_VAL_STRING	0x75
#define CMD_ME_SPECIAL_MODE	0x77
#define CMD_DO_SYSTEM_RESET	0x78
#define CMD_SPECIAL_RESERVED	0x79
#define CMD_RELEASE_INTERFACE	0x7A
#define CMD_GET_INTERF_SETTING	0x7B
#define CMD_SET_INTERF_SETTING	0x7C
#define CMD_PREPREAD_FTSENSOR	0x7D
#define CMD_STORE_DFILTER	0x7E
#define CMD_STORE_SIXAXCAL	0x7F
#define CMD_GETTXMODE	0x80
#define CMD_SETTXMODE	0x81
#define CMD_GET_DEBOUNCETIME	0x86
#define CMD_SET_DEBOUNCETIME	0x87
#define CMD_READDATARATE	0x8a
#define CMD_WRITEDATARATE	0x8b
#define CMD_GETCANSETTING	0x8c
#define CMD_SETCANSETTING	0x8d
#define CMD_GETANALOGUEFILTER	0x90
#define CMD_SETANALOGUEFILTER	0x91
#define CMD_SWITCHBLOCKING	0x92
#define CMD_GETCOMMANDAVAILABLE	0x93
#define CMD_GET_NOISECUT_THR	0x94
#define CMD_SET_NOISECUT_THR	0x95
#define CMD_READ_AUTOZ_SETTING	0x96
#define CMD_WRITE_AUTOZ_SETTING	0x97
#define CMD_GET_AUTOZ_PROPERTY	0x98
#define CMD_SET_AUTOZ_PROPERTY	0x99
#define CMD_GET_USEROFFSET	0x9A
#define CMD_SET_USEROFFSET	0x9B
#define CMD_GETINPUTTYP		0xA2
#define CMD_SETINPUTTYP		0xA3

#define BTCMD_INIT_CFG_MODE	0xE0
#define BTCMD_EXIT_CFG_MODE	0xE1
#define BTCMD_GET_BT_MAXPOWER	0xE2
#define BTCMD_SET_BT_MAXPOWER	0xE3
#define BTCMD_GET_LE_MAXPOWER	0xE4
#define BTCMD_SET_LE_MAXPOWER	0xE5
#define BTCMD_GET_BTMODE	0xE6
#define BTCMD_SET_BTMODE	0xE7
#define BTCMD_GET_NAME		0xE8
#define BTCMD_SET_NAME		0xE9
#define BTCMD_READ_BAT_VOLT	0xEA
#define BTCMD_DFU_RESET		0xEC
#define BTCMD_GET_GSVONOFF	0xED
#define BTCMD_SET_GSVONOFF	0xEE
#define BTCMD_SET_DEFAULT	0xEF
#define BTCMD_SET_INTYPE	0xEB
#define BTCMD_GET_INTYPE	0xF0
#define BTCMD_SET_DIO		0xF1
#define BTCMD_SET_LOGINTERVAL	0xF2
#define BTCMD_GET_LOGINTERVAL	0xF3

/* Cmd Indizes */
#define TXMODE_IX_MAX_RD 3
#define TXMODE_IX_MAX_WR 1
#define TXMODE_TXOFF_MASK 3
#define TXMODE_TXOFF_NOW 1

#define SENSORCALTYPMSK ~(SENSORCAL_TYP_TEDS_MEM)

/* Wait constants, related to device communication */
#define WAIT_AFTER_STOPTX_BEFORE_BUF_CLEAR 100	//war 300. Max TX: 680 Bits/19200= 35,4ms
#define WAIT_AFTER_STOPTX	200	//Wartezeit nach StopTx-Kommando innerhalb der Befehlsausfuehrung
#define MAX_BUS_LOAD 0.95	//maximale zeitliche Auslastung d. Schnittstellenbusses W: 0.1..1
#define WAIT_ACTIVATE 500 //Wartezeit am Ende der GSV8actExt in ms
#define WAIT_ACTIVATE_FACT 4	//mit ACTEX_FLAG_WAIT_EXTENDED: Wartezeit= WAIT_ACTIVATE*WAIT_ACTIVATE_FACT
#define TRIALS_GET_CMD 5	////mit ACTEX_FLAG_WAIT_EXTENDED: Anz. d. getMode-versuche in GSV8actExt
#define TIMEOUT_GSV_INIT 3000U   /* Erweitertes Timeout zB bei Handshake */
#define TIMEOUT_POLLFLOW 100U   /* Intervall fr Abfrage der Hardware-Flow-Control */
#define DELAY_BETWEEN_COMMANDS	80	//in ms, bei Schleifenaufrufen
//end of file